package cn.com.duiba.kjy.voice.service.api.enums;

/**
 * @Author chentiecheng
 * @Date 2021/2/19 2:45 下午
 */
public enum RedisKeyFactory {

    KS001("UserSig缓存"),
    KS002("直播信息缓存"),
    KS003("用户观看时长缓存"),
    ;

    private static final String SPACE = "KjyVoiceService";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
