package cn.com.duiba.kjy.voice.service.api.param.agentinvitation;

import cn.com.duiba.kjy.voice.service.api.param.common.PageQuery;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 语音直播代理人邀请表
 * @author kjj mybatis generator 
 * @date 2021-02-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class VoiceAgentInvitationSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16125782913412573L;

    /**
     * 直播代理人ID
     */
    private Long agentId;

    /**
     * 直播ID
     */
    private Long voiceId;

    /**
     * 是否到场：0-未到场，1-已到场
     */
    private Integer isPresent;

    /**
     * 是否直接邀请
     * @see cn.com.duiba.kjy.voice.service.api.enums.VoiceInviteDirectEnum
     */
    private Integer isDirectly;
    /**
     * 排序
     * @see cn.com.duiba.kjy.voice.service.api.enums.AgentInvitationSortTypeEnum
     */
    private Integer sort;
    /**
     * 代理人用户id
     */
    private Long agentUserId;

}