package cn.com.duiba.kjy.voice.service.api.param.voicelive;

import cn.com.duiba.kjy.voice.service.api.param.common.PageQuery;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 语音直播表
 * @author kjj mybatis generator 
 * @date 2021-02-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class VoiceLiveSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16125782913473757L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播代理人ID
     */
    private Long agentId;

    /**
     * 直播标题
     */
    private String liveTitle;

    /**
     * 宣传海报
     */
    private String posterUrl;

    /**
     * 开播时间
     */
    private Date broadcastTime;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 直播状态：1-未开始，2-直播中，3-断网，4-数据统计中 5-数据统计完成 6-数据统计失败
     */
    private Integer liveStatus;

    /**
     * 直播类型
     * @see cn.com.duiba.kjy.voice.service.api.enums.live.VoiceLiveTypeEnum
     */
    private Integer liveType;

    /**
     * 直播状态集合
     */
    private List<Integer> liveStatusList;
    /**
     * 排序。1按照开播时间
     */
    private Integer sort;
}