package cn.com.duiba.kjy.voice.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voiceagent.VoiceAgentDto;

/**
 * 语音直播代理人服务
 * @Author chentiecheng
 * @Date 2021/2/6 2:51 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceAgentService {

    /**
     * 保存语音直播代理人
     * @param dto
     * @return
     */
    Long insert(VoiceAgentDto dto);

    /**
     * 编辑语音直播代理人
     * @param dto
     * @return
     */
    Integer update(VoiceAgentDto dto);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    VoiceAgentDto findById(Long id);

    /**
     * 根据直播代理人id查询
     * @param liveAgentId
     * @return
     */
    VoiceAgentDto findByLiveAgentId(Long liveAgentId);
}
