package cn.com.duiba.kjy.voice.service.api.remoteservice.agentconsult;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voiceagentconsult.VoiceAgentConsultDto;
import cn.com.duiba.kjy.voice.service.api.param.agentconsult.VoiceAgentConsultSearchParam;

import java.util.List;

/**
 * 语音直播预约咨询服务
 * @Author chentiecheng
 * @Date 2021/2/6 2:52 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceAgentConsultService {
    /**
     * 根据条件查询咨询列表
     * @param param
     * @return
     */
    List<VoiceAgentConsultDto> selectListByPage(VoiceAgentConsultSearchParam param);

    /**
     * 根据直播id和用户id查询咨询列表
     * @param voiceId
     * @param liveUserIds
     * @return
     */
    List<VoiceAgentConsultDto> selectListByVoiceIdAndUserIds(Long voiceId,List<Long> liveUserIds);

    /**
     * 新增预约咨询
     * @param dto
     * @return
     */
    Boolean saveConsult(VoiceAgentConsultDto dto);

    /**
     * 根据直播id和用户id查询
     * @param voiceId
     * @param liveUserId
     * @return
     */
    VoiceAgentConsultDto selectByVoiceIdAndLiveUserId(Long voiceId,Long liveUserId);

    /**
     * 根据代理人用户id和直播id查询预约咨询人数
     * @param voiceId
     * @param agentUserId
     * @return
     */
    Integer selectConsultNum(Long voiceId,Long agentUserId);
}
