package cn.com.duiba.kjy.voice.service.api.remoteservice.agentinvitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voiceagentinvitation.VoiceAgentInvitationDto;
import cn.com.duiba.kjy.voice.service.api.dto.voiceagentinvitation.VoiceInvitationPresentNumDto;
import cn.com.duiba.kjy.voice.service.api.param.agentinvitation.VoiceAgentInvitationSearchParam;
import java.util.List;
import java.util.Map;

/**
 * 语音直播代理人邀请关系service
 * @Author chentiecheng
 * @Date 2021/2/6 2:52 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceAgentInvitationService {

    /**
     * 根据条件分页查询列表
     * @param param
     * @return
     */
    List<VoiceAgentInvitationDto> selectListByCondition(VoiceAgentInvitationSearchParam param);

    /**
     * 根据直播id和直播用户id列表查询
     * @param voiceId
     * @param liveUserIds
     * @return
     */
    List<VoiceAgentInvitationDto> selectListByVoiceIdAndLiveUserIds(Long voiceId,List<Long> liveUserIds);

    /**
     * 根据直播id和访客id查询关联关系
     * @param voiceId
     * @param liveUserId
     * @return
     */
    VoiceAgentInvitationDto selectByVoiceIdAndLiveUserId(Long voiceId,Long liveUserId);

    /**
     * 绑定代理人邀请关系
     * @param dto
     * @return
     */
    Boolean bindAgentInviteRelation(VoiceAgentInvitationDto dto);

    /**
     * 更新
     * @param voiceId
     * @param liveUserId
     * @return
     */
    Boolean updatePresent(Long voiceId,Long liveUserId);

    /**
     * 根据直播用户id，查询绑定条数
     * @param liveUserId
     * @return
     */
    Long findInvitationCountByLiveUserId(Long liveUserId);

    /**
     * 查询直播间到场人数
     * @param voiceIds
     * @return
     */
    List<VoiceInvitationPresentNumDto> selectVoicePresentNum(List<Long> voiceIds);
    /**
     * 查询邀请数
     * @param voiceId
     * @param agentUserId
     * @return
     */
    Long selectInvitationCount(Long voiceId, Long agentUserId);
    /**
     * 根据直播id列表和当前代理人用户id查询 该用户每场直播邀请的到场人数
     * @param voiceIds  直播id列表
     * @param liveUserId 直播用户id
     * @return
     */
    List<VoiceInvitationPresentNumDto> selectPresentNumByLiveIdsAndUserId(List<Long> voiceIds,Long liveUserId);

    /**
     * 查找用户绑定代理人用户ID
     * @param voiceId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：直播用户ID，value：绑定代理人用户ID
     */
    Map<Long, Long> findInvitationAgentUserIdMap(Long voiceId, List<Long> liveVisitorIdList);
}
