package cn.com.duiba.kjy.voice.service.api.remoteservice.agreement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.agreement.VoiceUserAgreementRecordDto;

import java.util.List;

/**
 * @author linjianhui
 * @description 用户同意协议记录
 * @date 2021/2/19 14:45
 */
@AdvancedFeignClient
public interface RemoteUserAgreementRecordApiService {

    /**
     * 根据用户和版本批量查询
     * @param liveUserIds 用户ID列表
     * @param agreementVersion 协议版本
     * @return 用户同意协议记录
     */
    List<VoiceUserAgreementRecordDto> batchFindByUserAndVersion(List<Long> liveUserIds, Integer agreementVersion);

    /**
     * 根据用户和版本查询
     * @param liveUserId
     * @param agreementVersion
     * @return
     */
    VoiceUserAgreementRecordDto findByUserAndVersion(Long liveUserId, Integer agreementVersion);

    /**
     * 保存用户同意协议记录
     * @param dto 代理人同意协议记录
     * @return 执行结果
     */
    int insert(VoiceUserAgreementRecordDto dto);

    /**
     * 批量保存用户同意协议记录
     * @param dtoList 代理人同意协议记录集合
     * @return 执行结果
     */
    int batchInsert(List<VoiceUserAgreementRecordDto> dtoList);
}
