package cn.com.duiba.kjy.voice.service.api.remoteservice.authtag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voiceauthtag.VoiceAuthTagDto;

import java.util.List;

/**
 * 语音直播 认证标签service
 * @Author chentiecheng
 * @Date 2021/2/6 2:52 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceAuthTagService {

    /**
     * 根据id列表查询标签
     * @param ids
     * @return
     */
    List<VoiceAuthTagDto> selectByIds(List<Long> ids);

    /**
     * 获取所有标签
     * @return
     */
    List<VoiceAuthTagDto> getAllTagList();

    /**
     * 新增标签
     * @param dto
     * @return
     */
    Boolean insert(VoiceAuthTagDto dto);
}
