package cn.com.duiba.kjy.voice.service.api.remoteservice.livestatistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voicelivestatistics.VoiceLiveStatisticsDto;

import java.util.List;

/**
 * 语音直播维度统计service
 * @Author chentiecheng
 * @Date 2021/2/6 2:53 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceLiveStatisticsService {

    /**
     * 根据直播id查询数据统计
     * @param voiceIds
     * @return
     */
    List<VoiceLiveStatisticsDto> selectListByVoiceIds(List<Long> voiceIds);

    /**
     * 根据直播id查询数据统计
     * @param voiceId
     * @return
     */
    VoiceLiveStatisticsDto selectStatisticsByVoiceId(Long voiceId);
}
