package cn.com.duiba.kjy.voice.service.api.remoteservice.team;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.team.VoiceLiveTeamMemberDto;
import cn.com.duiba.kjy.voice.service.api.param.team.VoiceLiveTeamMemberSearchParam;
import java.util.List;

/**
 * @author: linjianhui
 * @date: 2021/3/4 10:40
 * @description: 语音直播团队成员
 */
@AdvancedFeignClient
public interface RemoteVoiceLiveTeamMemberService {

    /**
     * 新增
     * @param dto 语音直播团队成员
     * @return 成员id
     */
    Long insert(VoiceLiveTeamMemberDto dto);

    /**
     * 查询团队人数
     * @param teamId 团队id
     * @return 团队成员
     */
    Long selectCountByTeamId(Long teamId);

    /**
     * 根据团队id和用户id查询
     * @param teamId 团队id
     * @param liveUserId 用户id
     * @return
     */
    VoiceLiveTeamMemberDto findByTeamIdAndUserId(Long teamId, Long liveUserId);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 语音直播团队成员集合
     */
    List<VoiceLiveTeamMemberDto> selectList(VoiceLiveTeamMemberSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(VoiceLiveTeamMemberSearchParam param);

    /**
     * 根据直播用户id查询用户加入的团队数
     * @param liveUserId 直播用户id
     * @return
     */
    Long selectCountByLiveUserId(Long liveUserId);

    /**
     * 删除团队成员
     * @param id 主键
     * @return 执行结果
     */
    int deleteById(Long id);

}
