package cn.com.duiba.kjy.voice.service.api.remoteservice.team;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.team.VoiceLiveTeamDto;

import java.util.List;

/**
 * @author: linjianhui
 * @date: 2021/3/4 10:39
 * @description: 语音直播团队
 */
@AdvancedFeignClient
public interface RemoteVoiceLiveTeamService {

    /**
     * 根据直播间id查询
     * @param voiceId
     * @return
     */
    VoiceLiveTeamDto selectByVoiceId(Long voiceId);

    /**
     * 根据主键id查询
     * @param id 主键
     * @return 语音直播团队
     */
    VoiceLiveTeamDto findById(Long id);

    /**
     * 根据直播id列表查询
     * @param voiceIds
     * @return
     */
    List<VoiceLiveTeamDto> selectByVoiceIds(List<Long> voiceIds);

    /**
     * 新增
     * @param dto 语音直播团队
     * @return 团队id
     */
    Long insert(VoiceLiveTeamDto dto);

    /**
     * 更新团队状态
     * @param id 团队id
     * @param teamStatus 团队状态
     * @return
     */
    int updateStatus(Long id,Integer teamStatus);

    /**
     * 根据id列表查询
     * @param ids
     * @return
     */
    List<VoiceLiveTeamDto> selectByIds(List<Long> ids);
}
