package cn.com.duiba.kjy.voice.service.api.remoteservice.tencent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author: linjianhui
 * @date: 2021/2/17 23:09
 * @description: im即时通讯相关api
 */
@AdvancedFeignClient
public interface RemoteImService {

    /**
     * 获取UserSig
     * 是用户登录即时通信 IM 的密码，其本质是对 UserID 等信息加密后得到的密文
     * @param liveUserId
     * @return
     */
    String getUserSig(Long liveUserId);

    /**
     * 解散群组
     * @param groupId 群组id
     * @return
     */
    Boolean destroyGroup(String groupId);

    /**
     * 创建群组
     * @param userId 群主id 取代理人用户id加密
     * @param groupId 群组id
     * @return
     */
    Boolean createGroup(String userId,String groupId);
}
