package cn.com.duiba.kjy.voice.service.api.remoteservice.tencent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.tencent.TencentVoiceRoomInfoDto;

/**
 * @author: linjianhui
 * @date: 2021/2/17 23:09
 * @description: 腾讯音视频相关api
 */
@AdvancedFeignClient
public interface RemoteTencentVoiceService {

    /**
     * 获取腾讯音视频直播间信息
     * @param roomId 语音直播间id 对应tb_voice_live表主键
     * @param liveUserId 客集集直播用户id
     * @return
     */
    TencentVoiceRoomInfoDto getTencentVoiceRoomInfo(Long roomId,Long liveUserId);

    /**
     * 解散房间
     * @param roomId 房间号
     * @return
     */
    Boolean dismissRoom(Long roomId);
}
