package cn.com.duiba.kjy.voice.service.api.remoteservice.userappointment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voiceuserappointment.VoiceUserAppointmentDto;
import cn.com.duiba.kjy.voice.service.api.dto.voiceuserappointment.VoiceUserAppointmentNumDto;
import cn.com.duiba.kjy.voice.service.api.param.userappointment.VoiceUserAppointmentSearchParam;

import java.util.List;

/**
 * 语音直播用户预约service
 * @Author chentiecheng
 * @Date 2021/2/6 2:54 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceUserAppointmentService {

    /**
     * 根据直播间id列表获取预约人数
     * @param voiceIds
     * @return
     */
    @Deprecated
    List<VoiceUserAppointmentNumDto> selectAppointmentNumByVoiceIds(List<Long> voiceIds,Integer type);
    /**
     * 根据直播间id列表和代理人用户id获取预约人数
     * @param voiceIds
     * @return
     */
    List<VoiceUserAppointmentNumDto> selectAppointmentNumByVoiceIdsAndUserId(List<Long> voiceIds,Integer type,Long liveUserId);

    /**
     * 分页查询直播预约列表
     * @param param
     * @return
     */
    List<VoiceUserAppointmentDto> selectAppointmentByCondition(VoiceUserAppointmentSearchParam param);

    /**
     * 根据直播id查询预约总数
     * @param voiceId
     * @return
     */
    Integer selectCountByVoiceId(Long voiceId,Integer type);

    /**
     * 根据直播id和用户id查询是否预约过
     * @param voiceId
     * @param liveUserId
     * @return
     */
    Integer selectCountByVoiceIdAndUserId(Long voiceId,Long liveUserId,Integer type);

    /**
     * 新增预约
     * @param dto
     * @return
     */
    Boolean addAppointment(VoiceUserAppointmentDto dto);

    /**
     * 批量更新新增
     * @param dtos
     * @return
     */
    Boolean batchInsertOrUpdate(List<VoiceUserAppointmentDto> dtos);

    /**
     * 根据直播id和用户列表查询
     * @param liveUserId
     * @param voiceId
     * @return
     */
    List<VoiceUserAppointmentDto> selectByLiveUserIdsAndVoice(List<Long> liveUserId,Long voiceId);

}
