package cn.com.duiba.kjy.voice.service.api.remoteservice.userstat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voiceuserstat.VoiceUserStatDto;

import java.util.List;

/**
 * 语音直播用户维度统计service
 * @Author chentiecheng
 * @Date 2021/2/6 2:54 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceUserStatService {

    /**
     * 根据直播id和用户id列表查询
     * @param voiceId
     * @param liveUserIds
     * @return
     */
    List<VoiceUserStatDto> selectListByVoiceIdAndLiveUserIds(Long voiceId,List<Long> liveUserIds);

    /**
     * 通过直播id获取访客数据列表
     * @param voiceId
     * @return
     */
    List<VoiceUserStatDto> findByVoiceId(Long voiceId);

    /**
     * 批量新增
     * @param list 直播线索-观看记录
     * @return 执行结果
     */
    int batchInsert(List<VoiceUserStatDto> list);

}
