package cn.com.duiba.kjy.voice.service.api.remoteservice.visitorinvitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voicevisitorinvitation.VoiceVisitorInvitationDto;

/**
 * 语音直播访客邀请关系service
 * @Author chentiecheng
 * @Date 2021/2/6 2:55 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceVisitorInvitationService {

    /**
     * 绑定访客邀请
     * @param dto
     * @return
     */
    Boolean bindInvitation(VoiceVisitorInvitationDto dto);

    /**
     * 根据直播id和访客id查询
     * @param voiceId
     * @param visitorId
     * @return
     */
    VoiceVisitorInvitationDto selectByVoiceIdAndVisitorId(Long voiceId,Long visitorId);

    /**
     * 根据直播id和邀请者id查询
     * @param voiceId
     * @param inviterId
     * @return
     */
    VoiceVisitorInvitationDto selectByVoiceIdAndInviterId(Long voiceId,Long inviterId);
}
