package cn.com.duiba.kjy.voice.service.api.remoteservice.voicelive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voicelive.VoiceLiveDto;
import cn.com.duiba.kjy.voice.service.api.param.voicelive.VoiceLiveSearchParam;

import java.util.List;

/**
 * 语音直播管理service
 * @Author chentiecheng
 * @Date 2021/2/6 2:53 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceLiveService {

    /**
     * 根据条件查询，分页
     * @param param
     * @return
     */
    List<VoiceLiveDto> selectPage(VoiceLiveSearchParam param);

    /**
     * 根据id查询直播详情
     * @param voiceId
     * @return
     */
    VoiceLiveDto selectById(Long voiceId);

    /**
     * 通过主键id批量查询
     * @param voiceIds
     * @return
     */
    List<VoiceLiveDto> findByIds(List<Long> voiceIds);

    /**
     * 新建直播
     * @param voiceLiveDto
     * @return
     */
    Long saveVoiceLive(VoiceLiveDto voiceLiveDto);

    /**
     * 结束直播间
     * @param voiceId
     * @return
     */
    Boolean finishVoiceLive(Long voiceId);

    /**
     * 直播统计失败重试
     * @param voiceId
     * @return
     */
    Boolean dataStatisticsFailedRetry(Long voiceId);

    /**
     * 更新直播
     * @param dto
     * @return
     */
    Boolean updateVoiceLive(VoiceLiveDto dto);

    /**
     * 修改直播状态
     * @param voiceId
     * @param status
     * @return
     */
    Boolean updateVoiceStatus(Long voiceId,Integer status);
}
