package cn.com.duiba.kvtable.service.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kvtable.service.api.dto.HbaseKvBackendDto;

/**
 * 为自动化测试用例提供的专用接口
 * Created by sunchangji on 2018/11/3.
 */
@AdvancedFeignClient
public interface RemoteAutoTestApiService {

    /**
     * 根据rowkey查询数据
     *
     * @param rowkey        主键rowkey
     * @param needReverseRowKey 是否需要反转key,true:反转,false:不反转
     * @return HbaseKvBackendDto
     */
    HbaseKvBackendDto findByRowKey(String rowkey, boolean needReverseRowKey);

    /**
     * 根据rowkey删除数据
     *
     * @param rowkey        主键rowkey
     * @param needReverseRowKey 是否需要反转key,true:反转,false:不反转
     */
    void deleteByRowkey(String rowkey, boolean needReverseRowKey);

    /**
     * 更新hbase对应rowkey数据
     * @param hbaseKvBackendDto
     * @return
     */
    HbaseKvBackendDto updateByRowKey(HbaseKvBackendDto hbaseKvBackendDto);

}
