package cn.com.duiba.kvtable.service.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * hbase rowkey的算法对应表
 * <p>
 * Created by sunchangji on 2019/1/22.
 */
public enum HbaseRowKeyTableEnum {
	//hbase rowkey的算法对应表
	NOT_DEAL(1, "duiba_kv", "不做处理的rowkey"),
	HASHKEY(2, "duiba_new_kv", "对habse的rowkey进行hash一致性算法"),
	REVERSE(3, "duiba_kv", "对rowkey进行反转");

	/**
	 * rowkey选择算法类型
	 */
	private int type;

	/**
	 * hbase表名
	 */
	private String tableName;
	/**
	 * 描述
	 */
	private String desc;

	private static Map<Integer,HbaseRowKeyTableEnum> rowkeyMap = Maps.newHashMap();

	HbaseRowKeyTableEnum(int type, String tableName, String desc) {
		this.type = type;
		this.tableName = tableName;
		this.desc = desc;
	}

	static{
		for(HbaseRowKeyTableEnum tableEnum : HbaseRowKeyTableEnum.values()){
			rowkeyMap.put(tableEnum.getType(),tableEnum);
		}
	}


	public int getType() {
		return type;
	}

	public String getTableName() {
		return tableName;
	}

	public String getDesc() {
		return desc;
	}

	/**
	 * 根据type获取具体枚举类型
	 * @param type
	 * @return
	 */
	public static HbaseRowKeyTableEnum getByType(Integer type){
		return rowkeyMap.get(type);
	}
}
