package cn.com.duiba.kvtable.service.api.enums;

/**
 * PrizeCenterHBaseKeyEnum
 * prize-center Hbase第二段key枚举类
 *
 * @author ChenXiangge
 * @date 23/07/2018
 */
public enum PrizeCenterHBaseKeyEnum {
    K001("用户中奖每日限制次数"),
    K002("用户中奖每周限制次数"),
    K003("用户中奖每月限制次数"),
    K004("奖品每日发放限制"),
    K005("奖品每周发放限制"),
    K006("奖品每月发放限制"),
    K007("爱奇艺定制奖品信息"),
    K008("浙江农行夺宝签到奖项已发数量"),
    ;
    private String desc;

    PrizeCenterHBaseKeyEnum(String desc){
        this.desc = desc;
    }

    /**
     * prize-center:prize-center HBase key space
     */
    private static final String SPACE = "PRIZE";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString()+"_";
    }
}
