package cn.com.duiba.kvtable.service.api.enums;

/**
 * PrizeCenterHBaseKeyEnum
 * prize-center Hbase第二段key枚举类
 *
 * @author ChenXiangge
 * @date 23/07/2018
 */
public enum HdtoolCenterHBaseKeyEnum {
    K001("【投票工具】拉票排行榜名次称谓配置"),
    K002("【投票工具】得票排行榜名次称谓配置"),
    K003("【投票工具】报名需要所需信息配置"),
    K004("【投票工具】用户报名信息"),
    ;
    private String desc;

    HdtoolCenterHBaseKeyEnum(String desc){
        this.desc = desc;
    }

    /**
     * prize-center:hdtool-center HBase key space
     */
    private static final String SPACE = "HDTOOLCENTER";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString()+"_";
    }
}
