package cn.com.duiba.kvtable.service.api.enums;

/**
 * 风控统计数据hbase key枚举
 */
public enum AnticheatCenterHBaseKeyEnum {
  K001("用户在一段时间内某个ip为他助力最大次数"),
  K002("同一个收货手机号绑定的用户id"),

  ;
  private String desc;

  AnticheatCenterHBaseKeyEnum(String desc){
    this.desc = desc;
  }

  /**
   * anticheat-center:anticheat-center HBase key space
   */
  private static final String SPACE = "ANTICHEAT";

  public String getDesc() {
    return desc;
  }

  /**
   * 拼接key前置
   */
  @Override
  public String toString() {
    return SPACE + "_" + super.toString()+"_";
  }
}
