package cn.com.duiba.kvtable.service.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kvtable.service.api.dto.HbApiKLongVDto;
import cn.com.duiba.kvtable.service.api.dto.HbApiKStrVDto;
import cn.com.duiba.kvtable.service.api.dto.HbaseKvDto;
import cn.com.duiba.kvtable.service.api.params.hbapi.HbKStrVParam;

import java.util.List;

/**
 * 字符串类型的rowkey设计部规律的情况下,推荐使用
 * 由于字符串类型的rowkey很难保证分区数据一致性,该类的实现是为了保证大致rowkey在分区上保证数据大致分布均匀
 * 在建立hbase表的时候设置了很多优化参数
 *
 * Created by sunchangji on 2018/12/24.
 */
@AdvancedFeignClient
public interface RemoteHbConsisHashKvService {

	/**
	 * 根据rowkey获取value是string类型的值
	 *
	 * @param rowkey
	 * @return null表示不存在或该存储的值不是String类型
	 */
	String getStringByKey(String rowkey);

	/**
	 * 增加或更新字符串的value
	 *
	 * @param rowkey
	 * @param value
	 * @return
	 */
	boolean upsertKStrV(String rowkey, String value);

	/**
	 * 根据key获取value是long型的值,如果不是long的值会返回null
	 *
	 * @param rowkey
	 * @return nnull表示不存在或该存储的值不是Long型
	 */
	Long getLongByKey(String rowkey);

	/**
	 * 增加或更新long类型的value
	 *
	 * @param rowkey
	 * @param value
	 * @return
	 */
	boolean upsertKLongV(String rowkey, long value);

	/**
	 * 对key的long value做increase操作,不存在会新增一条记录
	 *
	 * @param rowkey
	 * @param incrNum
	 * @return 返回increase后的值
	 */
	Long increaseByKey(String rowkey, long incrNum);

	/**
	 * 根据key删除
	 *
	 * @param rowkey
	 */
	void deleteByKey(String rowkey);

	/**
	 * 批量删除
	 *
	 * @param rowkeys
	 */
	void batchDeleteByKeys(List<String> rowkeys);

	/**
	 * 根据key批量查询value是long类型
	 * 只要查到是按照传入的顺序,不存在的key是不会在返回的数据列表中
	 *
	 * @param keys
	 * @return
	 */
	List<HbApiKLongVDto> batchFindLongVBykeys(List<String> keys);


	/**
	 * 根据key批量查询value是string类型
	 * 只要查到是按照传入的顺序,不存在的key是不会在返回的数据列表中
	 *
	 * @param keys
	 * @return
	 */
	List<HbApiKStrVDto> batchFindStrVBykeys(List<String> keys);

	/**
	 * 批量增加或更新value是字符串的value
	 *
	 * @param list
	 * @return
	 */
	void batchUpsertStrV(List<HbKStrVParam> list);

	/**
	 * 根据rowkey获取long和string存储的值
	 * @param rowKey
	 * @return
	 */
	HbaseKvDto findByRowKey(String rowKey);

	/**
	 * 新增一个rowkey两个值,long和string存储的值
	 * @param hbaseKvDto
	 * @return
	 */
	boolean insertKvDto(HbaseKvDto hbaseKvDto);

}
