package cn.com.duiba.kvtable.service.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kvtable.service.api.dto.HbApiKLongVDto;
import cn.com.duiba.kvtable.service.api.dto.HbApiKStrVDto;
import cn.com.duiba.kvtable.service.api.params.hbapi.HbKStrVParam;
import cn.com.duiba.kvtable.service.api.params.hbapi.HbLongVParam;

import java.util.List;

/**
 * 已废弃,推荐使用RemoteHbConsisHashKvService
 * 原生HBase api方式实现 key value存储数据
 * <p>
 * key的前缀请在kvtable-service定义枚举类,避免key冲突
 * <p>
 * Created by sunchangji on 2018/7/31.
 */
@Deprecated
@AdvancedFeignClient
public interface RemoteHbaseApiKvService {

    /**
     * 根据key获取value是long型的值,如果不是long的值会返回null
     *
     * @param key
     * @return nnull表示不存在或该存储的值不是Long型
     */
    Long getLongByKey(String key);

    /**
     * 根据key获取value是string类型的值
     *
     * @param key
     * @return null表示不存在或该存储的值不是String类型
     */
    String getStringByKey(String key);

    /**
     * 增加或更新字符串的value
     *
     * @param key
     * @param value
     * @return
     */
    boolean upsertKStrV(String key, String value);

    /**
     * 增加或更新long类型的value
     *
     * @param key
     * @param value
     * @return
     */
    boolean upsertKLongV(String key, long value);

    /**
     * 对key的long value做increase操作,不存在会新增一条记录
     *
     * @param key
     * @param incrNum
     * @return 返回increase后的值
     */
    Long increaseByKey(String key, long incrNum);

    /**
     * 批量增加或更新value是字符串的value
     *
     * @param hbKStrVParams
     */
    boolean batchUpsertStrV(List<HbKStrVParam> hbKStrVParams);

    /**
     * 批量增加或更新value是long型的value
     *
     * @param hbLongVParams
     */
    boolean batchUpsertLongV(List<HbLongVParam> hbLongVParams);

    /**
     * 根据key批量查询value是字符串类型
     * 只要查到是按照传入的顺序,不存在的key是不会在返回的数据列表中
     *
     * @param keys
     * @return
     */
    List<HbApiKStrVDto> batchFindStrVBykeys(List<String> keys);

    /**
     * 根据key批量查询value是long类型
     * 只要查到是按照传入的顺序,不存在的key是不会在返回的数据列表中
     *
     * @param keys
     * @return
     */
    List<HbApiKLongVDto> batchFindLongVBykeys(List<String> keys);


    /**
     * 根据key删除
     * @param key
     */
    void deleteByKey(String key);

    /**
     * 批量删除
     *
     * @param keys
     */
    void batchDeleteByKeys(List<String> keys);
}
