package cn.com.duiba.linglong.client.service.logger;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author liuyao
 */
@Slf4j
public class JobLogger {

    public static final int JOB_LOG_CONUT_LIMIT = 10000;

    private final JobLogService jobLogService;

    private final JobKey jobKey;

    private final AtomicInteger jobLogCount = new AtomicInteger(0);

    private volatile boolean isUp = false;

    protected JobLogger(JobLogService jobLogService, JobKey jobKey){
        this.jobLogService = jobLogService;
        this.jobKey = jobKey;
    }

    public JobKey getJobKey() {
        return jobKey;
    }

    public void log(String log) {
        log(null,log);
    }

    public void error(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        log(Level.ERROR,sw.toString());
    }

    public void log(Level level,String logContent){
        if(StringUtils.isBlank(logContent)){
            return;
        }
        int count = jobLogCount.getAndIncrement();
        if(count > JOB_LOG_CONUT_LIMIT){
            if(!isUp){
                String context = "任务["+jobKey.key()+"]日志量超过"+JOB_LOG_CONUT_LIMIT+",无法继续记录";
                JobLog jobLog = new JobLog();
                jobLog.setActionTime(System.currentTimeMillis());
                jobLog.setLogContent(context);
                jobLog.setLevel(Level.ERROR.toString());
                jobLogService.acceptLog(jobKey,jobLog);
            }
            isUp = true;
            return;
        }
        JobLog jobLog = new JobLog();
        jobLog.setActionTime(System.currentTimeMillis());
        jobLog.setLogContent(logContent);
        jobLog.setLevel(Optional.ofNullable(level).orElse(Level.INFO).toString());
        jobLogService.acceptLog(jobKey,jobLog);
    }

}
