package cn.com.duiba.linglong.client.job.render;

import cn.com.duiba.linglong.client.job.interceptor.JobInterceptor;
import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import cn.com.duiba.linglong.client.job.jobs.JobContext;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/**
 * 预处理任务脚本
 * @author liuyao
 */
@Slf4j
public class JobScriptInterceptor implements JobInterceptor {

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public boolean preHandle(AbstractJob job) {
        JobContext jobContext = job.getJobContext();
        //记录任务执行用户
        job.log("任务执行用户:" + jobContext.getOwner());
        //记录日志的参考时间点
        job.log("任务参照时间:" + DateUtils.getSecondStr(jobContext.getTime()));

        ConfigRender configRender = applicationContext.getBean(ConfigRender.class);
        configRender.setRepository(jobContext);
        //预处理配置
        prepareProperties(configRender,jobContext);
        //渲染脚本
        jobContext.setScript(renderScript(configRender,jobContext.getScript()));
        return true;
    }

    /**
     * @param jobContext 需要编译的配置
     */
    public void prepareProperties(ConfigRender configRender,JobContext jobContext) throws IllegalArgumentException {
        DateTool dateTool = new DateTool(jobContext.getTime()).addDay(-1);
        jobContext.put("yesterday", dateTool.format("yyyyMMdd"));
        jobContext.put("date", dateTool.format("yyyy-MM-dd"));
        //配置依赖的配置
        List<String> waitRanderKeys = Lists.newArrayList();
        for(String key:jobContext.stringPropertyNames()){
            String value = jobContext.getProperty(key);
            //判断配置value依赖的配置
            Collection<String> needKeys = ConfigRender.analyseScript(value);
            if(!needKeys.isEmpty()) {
                //标记需要渲染的key
                waitRanderKeys.add(key);
            }
        }
        for (String key : waitRanderKeys) {
            String renderValue = configRender.getRenderConfig(key);
            //用渲染后的值替换原来的值
            jobContext.put(key,renderValue);
        }
    }

    public String renderScript(ConfigRender configRender,String script){
        if(StringUtils.isBlank(script)){
            return script;
        }
        //脚本中依赖配置的Keys
        Set<String> keys = ConfigRender.analyseScript(script);
        Properties model = new Properties();
        for(String key:keys){
            model.put(key,configRender.getRenderConfig(key));
        }
        return ConfigRender.replaceArgs(script, model);
    }

}
