/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.cluster.zookeeper;

import cn.com.duiba.linglong.client.cluster.zookeeper.ZookeeperProperties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ZookeeperProperties.class})
public class ZookeeperConfiguration {
    @Bean(initMethod="start", destroyMethod="close")
    public CuratorFramework curatorFramework(ZookeeperProperties canalZookeeperProperties, RetryPolicy retryPolicy) {
        return CuratorFrameworkFactory.builder().connectString(canalZookeeperProperties.getHosts()).retryPolicy(retryPolicy).namespace(canalZookeeperProperties.getNamespace()).connectionTimeoutMs(60000).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryPolicy retryPolicy(ZookeeperProperties canalZookeeperProperties) {
        return new ExponentialBackoffRetry(canalZookeeperProperties.getBaseSleepTime().intValue(), canalZookeeperProperties.getMaxRetries().intValue());
    }
}

