/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.consumer;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.linglong.client.cluster.hazelcast.Node;
import cn.com.duiba.linglong.client.cluster.hazelcast.ZookeeperDiscoveryStrategy;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.job.consumer.JobConsumerAssert;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.linglong.client.remoteservice.RemoteWorkerStatusService;
import cn.com.duiba.linglong.client.service.channel.JobConsumerChannel;
import cn.com.duiba.linglong.client.service.channel.JobConsumerChannelManager;
import cn.com.duiba.linglong.client.service.channel.JobInvoker;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import java.util.List;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.curator.x.discovery.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;

public class WorkerJobConsumer
extends AbstractExecutionThreadService {
    private static final Logger log = LoggerFactory.getLogger(WorkerJobConsumer.class);
    @Resource
    private List<JobConsumerAssert> jobConsumerAsserts;
    @Resource
    private JobConsumerChannelManager jobConsumerChannelManager;
    @Resource
    private WorkerScheduleJobManager workerScheduleJobManager;
    @Resource
    private ZookeeperDiscoveryStrategy zookeeperDiscoveryStrategy;
    @Resource
    private RemoteWorkerStatusService remoteWorkerStatusService;
    @Value(value="${spring.application.name}")
    private String appName;
    private JobConsumerChannel jobConsumerChannel;
    private Thread heartbeat;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void startConsumer() {
        this.jobConsumerChannel = this.jobConsumerChannelManager.getJobConsumerChannel(this.appName);
        this.startAsync();
        WorkerJobConsumer consumer = this;
        this.heartbeat = new Thread(() -> {
            consumer.awaitRunning();
            while (this.isRunning()) {
                try {
                    ServiceInstance<Node> instance = this.zookeeperDiscoveryStrategy.getThisServiceInstance();
                    this.remoteWorkerStatusService.heartbeat(instance.getName(), instance.getId());
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    log.error("\u5fc3\u8df3\u4e0a\u62a5\u5931\u8d25", (Throwable)e);
                }
            }
        });
        this.heartbeat.setDaemon(true);
        this.heartbeat.setName("linglong.client.heartbeat");
        this.heartbeat.setPriority(10);
        this.heartbeat.start();
    }

    @PreDestroy
    public void preDestroy() {
        if (this.isRunning()) {
            this.stopAsync();
        }
    }

    protected void triggerShutdown() {
        this.heartbeat.interrupt();
        ServiceInstance<Node> instance = this.zookeeperDiscoveryStrategy.getThisServiceInstance();
        this.remoteWorkerStatusService.stopWorker(instance.getName(), instance.getId());
    }

    protected void startUp() {
        log.info("Worker\u4efb\u52a1\u6d88\u8d39\u901a\u9053\u6784\u5efa\u5b8c\u6210");
    }

    public void run() {
        while (this.isRunning()) {
            try {
                if (!this.canRunJob()) {
                    int retryTime = 3;
                    for (int i = 0; i < retryTime; ++i) {
                        if (!this.isRunning()) {
                            return;
                        }
                        Thread.sleep(1000L);
                    }
                    continue;
                }
                JobInvoker invoker = this.jobConsumerChannel.takeJob();
                if (Objects.isNull(invoker)) {
                    Thread.sleep(1000L);
                    if (this.isRunning()) continue;
                    return;
                }
                try {
                    JobKey jobKey = new JobKey("action", invoker.getHistoryId());
                    this.workerScheduleJobManager.submitScheduleJob(jobKey, invoker.getJobLevel());
                }
                catch (Exception e) {
                    log.error("\u4efb\u52a1\u8fd0\u884c\u5931\u8d25", (Throwable)e);
                }
            }
            catch (HazelcastClientNotActiveException | HazelcastInstanceNotActiveException | InterruptedException e) {
                break;
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u6d88\u8d39\u7ba1\u9053\u5f02\u5e38", (Throwable)e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean canRunJob() {
        for (JobConsumerAssert consumerAssert : this.jobConsumerAsserts) {
            if (consumerAssert.canConsumer()) continue;
            return false;
        }
        return true;
    }
}

