/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.monitor;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.linglong.client.job.consumer.JobConsumerAssert;
import cn.com.duiba.linglong.client.monitor.MonitorProperties;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class MemUseRateInfoService
implements JobConsumerAssert {
    private static final Logger log = LoggerFactory.getLogger(MemUseRateInfoService.class);
    @Resource
    private Environment currentEnvironment;
    @Resource
    private MonitorProperties monitorProperties;
    private volatile Float memUseRate = Float.valueOf(0.0f);
    private final OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    @Scheduled(cron="0/3 * * * * ?")
    public void runOneIteration() {
        if (this.currentEnvironment == Environment.DEV) {
            this.memUseRate = this.monitorProperties.getMaxMemRate();
            return;
        }
        long totalvirtualMemory = this.osmxb.getTotalSwapSpaceSize();
        long freePhysicalMemorySize = this.osmxb.getFreePhysicalMemorySize();
        this.memUseRate = Float.valueOf(1.0f - (float)freePhysicalMemorySize * 1.0f / (float)totalvirtualMemory);
    }

    @Override
    public boolean canConsumer() {
        float maxMemRate = this.monitorProperties.getMaxMemRate().floatValue();
        if (this.memUseRate.floatValue() > maxMemRate) {
            log.info("\u5185\u5b58\u8fc7\u8f7d\uff1amax(" + maxMemRate + "),current:(" + this.memUseRate + ")");
            return false;
        }
        return true;
    }
}

