/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.service.channel;

import cn.com.duiba.linglong.client.service.channel.JobInvoker;
import cn.com.duiba.linglong.client.service.channel.JobLevel;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.core.HazelcastInstance;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobConsumerChannel {
    private static final Logger log = LoggerFactory.getLogger(JobConsumerChannel.class);
    @Resource
    private HazelcastInstance linglongHazelcastClient;
    private IQueue<Long> high;
    private IQueue<Long> middle;
    private IQueue<Long> lower;
    private ISet<Long> jobKeySet;

    public void init(String appName) {
        this.high = this.linglongHazelcastClient.getQueue("JobConsumerChannel.high:" + appName);
        this.middle = this.linglongHazelcastClient.getQueue("JobConsumerChannel.middle:" + appName);
        this.lower = this.linglongHazelcastClient.getQueue("JobConsumerChannel.lower:" + appName);
        this.jobKeySet = this.linglongHazelcastClient.getSet("JobConsumerChannel.jobKeySet");
    }

    public JobInvoker takeJob() {
        JobInvoker invoker = this.take();
        if (Objects.isNull(invoker)) {
            return null;
        }
        if (this.jobKeySet.remove((Object)invoker.getHistoryId())) {
            return invoker;
        }
        return null;
    }

    private JobInvoker take() {
        try {
            Long historyId = (Long)this.high.poll();
            if (Objects.nonNull(historyId)) {
                JobInvoker invoker = new JobInvoker();
                invoker.setJobLevel(JobLevel.HIGH);
                invoker.setHistoryId(historyId);
                return invoker;
            }
            historyId = (Long)this.middle.poll();
            if (Objects.nonNull(historyId)) {
                JobInvoker invoker = new JobInvoker();
                invoker.setJobLevel(JobLevel.MIDDLE);
                invoker.setHistoryId(historyId);
                return invoker;
            }
            historyId = (Long)this.lower.poll(2L, TimeUnit.SECONDS);
            if (Objects.nonNull(historyId)) {
                JobInvoker invoker = new JobInvoker();
                invoker.setJobLevel(JobLevel.LOWER);
                invoker.setHistoryId(historyId);
                return invoker;
            }
            return null;
        }
        catch (InterruptedException e) {
            log.error("\u6d88\u8d39\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    void pushJobKey(JobLevel jobLevel, Long historyId) {
        if (this.jobKeySet.contains((Object)historyId)) {
            return;
        }
        try {
            this.jobKeySet.add((Object)historyId);
            switch (jobLevel) {
                case HIGH: {
                    this.high.add((Object)historyId);
                    break;
                }
                case LOWER: {
                    this.lower.add((Object)historyId);
                    break;
                }
                default: {
                    this.middle.add((Object)historyId);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u5931\u8d25", (Throwable)e);
            this.jobKeySet.remove((Object)historyId);
        }
    }

    void removeJobKey(Long historyId) {
        this.jobKeySet.remove((Object)historyId);
    }
}

