/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.service.channel;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import cn.com.duiba.linglong.client.service.channel.JobConsumerChannel;
import cn.com.duiba.linglong.client.service.channel.JobInvoker;
import cn.com.duiba.linglong.client.service.channel.JobLevel;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

public class JobConsumerChannelManager {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private RemoteApplicationService remoteApplicationService;
    private final LoadingCache<String, JobConsumerChannel> consumerChannelMap = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, JobConsumerChannel>(){

        @NotNull
        public JobConsumerChannel load(@NonNull String appName) {
            ApplicationDto application = JobConsumerChannelManager.this.remoteApplicationService.getApplicationByAlias(appName);
            if (Objects.isNull(application) || application.getAbandoned().booleanValue()) {
                throw new RuntimeException("\u65e0\u6548\u7684\u5e94\u7528:" + appName);
            }
            JobConsumerChannel channel = (JobConsumerChannel)JobConsumerChannelManager.this.applicationContext.getBean(JobConsumerChannel.class);
            channel.init(appName);
            return channel;
        }
    });

    public void acceptJob(String appName, JobInvoker invoker) {
        Objects.requireNonNull(appName);
        JobConsumerChannel channel = (JobConsumerChannel)this.consumerChannelMap.get((Object)appName);
        Objects.requireNonNull(channel);
        JobLevel level = Optional.ofNullable(invoker.getJobLevel()).orElse(JobLevel.MIDDLE);
        channel.pushJobKey(level, invoker.getHistoryId());
    }

    public void removeJob(String appName, Long historyId) {
        JobConsumerChannel channel = (JobConsumerChannel)this.consumerChannelMap.get((Object)appName);
        Objects.requireNonNull(channel);
        channel.removeJobKey(historyId);
    }

    public JobConsumerChannel getJobConsumerChannel(String appName) {
        return (JobConsumerChannel)this.consumerChannelMap.get((Object)appName);
    }
}

