/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.service.logger;

import cn.com.duiba.linglong.client.WorkerSdkProperties;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.service.logger.JobLog;
import cn.com.duiba.linglong.client.service.logger.JobLogSessionService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.google.common.collect.Lists;
import com.hazelcast.collection.ISet;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

public class JobLogService {
    @Resource
    private HazelcastInstance hazelcastInstance;
    @Resource
    private JobLogSessionService jobLogSessionService;
    @Resource
    private WorkerSdkProperties workerSdkProperties;
    private ISet<String> logKeySet;
    private MultiMap<String, JobLog> jobLogMultiMap;
    private IMap<String, List<JobLog>> delayLogMap;

    @PostConstruct
    public void init() {
        this.logKeySet = this.hazelcastInstance.getSet("JobLogService.logKeySet");
        this.jobLogMultiMap = this.hazelcastInstance.getMultiMap("JobLogService.jobLogMultiMap");
        this.delayLogMap = this.hazelcastInstance.getMap("JobLogService.delayLogMap");
    }

    public void startLog(JobKey jobKey) {
        this.logKeySet.add((Object)jobKey.key());
    }

    public void acceptLog(JobKey jobKey, JobLog jobLog) {
        String key = jobKey.key();
        if (!this.logKeySet.contains((Object)key) || this.workerSdkProperties.getTestModel().booleanValue()) {
            return;
        }
        jobLog.setUuid(UUIDUtils.createUUID());
        this.jobLogMultiMap.put((Object)key, (Object)jobLog);
        this.jobLogSessionService.acceptLog(jobKey, jobLog);
    }

    public Collection<JobLog> releaseLog(JobKey jobKey) {
        String key = jobKey.key();
        this.logKeySet.remove((Object)key);
        Collection logs = this.jobLogMultiMap.remove((Object)key);
        if (!logs.isEmpty()) {
            this.delayLogMap.put((Object)key, (Object)Lists.newArrayList((Iterable)logs), 5L, TimeUnit.SECONDS);
        }
        return logs;
    }

    public List<JobLog> findLogsByJobKey(JobKey jobKey) {
        String key = jobKey.key();
        if (this.logKeySet.contains((Object)key)) {
            return Lists.newArrayList((Iterable)this.jobLogMultiMap.get((Object)key));
        }
        if (this.delayLogMap.containsKey((Object)key)) {
            return (List)this.delayLogMap.get((Object)key);
        }
        return Collections.emptyList();
    }
}

