/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.service.logger;

import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.responce.FetchJobLogResult;
import cn.com.duiba.linglong.client.service.logger.JobLog;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.google.common.collect.Sets;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class JobLogSessionService {
    private static final long SESSION_TIMEOUT = 10000L;
    @Resource
    private HazelcastInstance linglongHazelcastClient;
    private MultiMap<String, JobLog> jobLogMultimap;
    private MultiMap<String, String> sessionMultimap;
    private IMap<String, Long> sessionTimeMap;
    private IMap<String, String> sessionBiMap;

    @PostConstruct
    public void init() {
        this.jobLogMultimap = this.linglongHazelcastClient.getMultiMap("JobLogSessionService.jobLogMultimap");
        this.sessionMultimap = this.linglongHazelcastClient.getMultiMap("JobLogSessionService.sessionMultimap");
        this.sessionTimeMap = this.linglongHazelcastClient.getMap("JobLogSessionService.sessionTimeMap");
        this.sessionBiMap = this.linglongHazelcastClient.getMap("JobLogSessionService.sessionBiMap");
    }

    public String createSession(JobKey jobKey) {
        String sessionId = UUIDUtils.createUUID();
        this.sessionTimeMap.put((Object)sessionId, (Object)System.currentTimeMillis());
        this.sessionMultimap.put((Object)jobKey.key(), (Object)sessionId);
        this.sessionBiMap.put((Object)sessionId, (Object)jobKey.key());
        return sessionId;
    }

    public FetchJobLogResult fetchJobLog(String sessionId) {
        FetchJobLogResult result = new FetchJobLogResult();
        boolean hasSession = this.sessionTimeMap.containsKey((Object)sessionId);
        if (hasSession) {
            this.sessionTimeMap.put((Object)sessionId, (Object)System.currentTimeMillis());
        }
        result.setHasSession(hasSession);
        result.setLogs(this.jobLogMultimap.remove((Object)sessionId));
        return result;
    }

    public void closeSession(String sessionId) {
        this.sessionTimeMap.remove((Object)sessionId);
        this.jobLogMultimap.remove((Object)sessionId);
        String jobKey = (String)this.sessionBiMap.remove((Object)sessionId);
        if (StringUtils.isNotBlank((String)jobKey)) {
            this.sessionMultimap.remove((Object)jobKey, (Object)sessionId);
        }
    }

    public void scanSession() {
        HashSet sessionIdSet = Sets.newHashSet((Iterable)this.sessionBiMap.keySet());
        for (String sessionId : sessionIdSet) {
            Long time = (Long)this.sessionTimeMap.get((Object)sessionId);
            if (!Objects.isNull(time) && time - System.currentTimeMillis() <= 10000L) continue;
            this.closeSession(sessionId);
        }
    }

    void acceptLog(JobKey jobKey, JobLog jobLog) {
        Collection sessionIds = this.sessionMultimap.get((Object)jobKey.key());
        for (String sessionId : sessionIds) {
            if (!this.sessionTimeMap.containsKey((Object)sessionId)) continue;
            this.jobLogMultimap.put((Object)sessionId, (Object)jobLog);
        }
    }

    public void releaseLog(JobKey jobKey) {
        Collection sessionIds = this.sessionMultimap.get((Object)jobKey.key());
        for (String sessionId : sessionIds) {
            this.sessionTimeMap.remove((Object)sessionId);
        }
        this.sessionMultimap.remove((Object)jobKey.key());
    }
}

