/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.service.logger;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.service.logger.JobLog;
import cn.com.duiba.linglong.client.service.logger.JobLogService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogger {
    private static final Logger log = LoggerFactory.getLogger(JobLogger.class);
    public static final int JOB_LOG_CONUT_LIMIT = 10000;
    private final JobLogService jobLogService;
    private final JobKey jobKey;
    private final AtomicInteger jobLogCount = new AtomicInteger(0);
    private volatile boolean isUp = false;

    protected JobLogger(JobLogService jobLogService, JobKey jobKey) {
        this.jobLogService = jobLogService;
        this.jobKey = jobKey;
    }

    public JobKey getJobKey() {
        return this.jobKey;
    }

    public void log(String log) {
        this.log(null, log);
    }

    public void error(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.log(Level.ERROR, sw.toString());
    }

    public void log(Level level, String logContent) {
        if (StringUtils.isBlank((String)logContent)) {
            return;
        }
        int count = this.jobLogCount.getAndIncrement();
        if (count > 10000) {
            if (!this.isUp) {
                String context = "\u4efb\u52a1[" + this.jobKey.key() + "]\u65e5\u5fd7\u91cf\u8d85\u8fc7" + 10000 + ",\u65e0\u6cd5\u7ee7\u7eed\u8bb0\u5f55";
                JobLog jobLog = new JobLog();
                jobLog.setActionTime(System.currentTimeMillis());
                jobLog.setLogContent(context);
                jobLog.setLevel(Level.ERROR.toString());
                this.jobLogService.acceptLog(this.jobKey, jobLog);
            }
            this.isUp = true;
            return;
        }
        JobLog jobLog = new JobLog();
        jobLog.setActionTime(System.currentTimeMillis());
        jobLog.setLogContent(logContent);
        jobLog.setLevel(Optional.ofNullable(level).orElse(Level.INFO).toString());
        this.jobLogService.acceptLog(this.jobKey, jobLog);
    }
}

