/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.interceptor;

import cn.com.duiba.linglong.client.exception.WorkerException;
import cn.com.duiba.linglong.client.job.interceptor.JobInterceptor;
import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import cn.com.duiba.linglong.client.job.jobs.JobContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithProcesserJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(WithProcesserJob.class);
    private AbstractJob job;
    private List<JobInterceptor> interceptors = Collections.emptyList();
    private int interceptorIndex = -1;

    public void setInterceptors(List<JobInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setJob(AbstractJob job) {
        this.job = job;
    }

    @Override
    public void run() throws WorkerException {
        if (Objects.isNull(this.job)) {
            return;
        }
        try {
            if (this.applyPreHandle(this.job) && this.job.isRunning()) {
                this.job.run();
            }
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WorkerException(e);
        }
        finally {
            this.applyPostHandle(this.job);
        }
    }

    @Override
    protected void cancelInternal() {
        if (Objects.nonNull(this.job) && this.job.isRunning()) {
            this.job.cancel();
        }
    }

    @Override
    public JobContext getJobContext() {
        return Optional.ofNullable(this.job).map(AbstractJob::getJobContext).orElse(null);
    }

    @Override
    public boolean isRunning() {
        if (Objects.isNull(this.job)) {
            return false;
        }
        return this.job.isRunning();
    }

    private boolean applyPreHandle(AbstractJob job) throws WorkerException {
        if (this.interceptors.size() != 0) {
            int i = 0;
            while (i < this.interceptors.size()) {
                JobInterceptor interceptor = this.interceptors.get(i);
                if (!interceptor.preHandle(job)) {
                    return false;
                }
                this.interceptorIndex = i++;
            }
        }
        return true;
    }

    private void applyPostHandle(AbstractJob job) {
        if (this.interceptors.size() != 0) {
            for (int i = this.interceptorIndex; i >= 0; --i) {
                JobInterceptor interceptor = this.interceptors.get(i);
                try {
                    interceptor.postHandle(job);
                    continue;
                }
                catch (Throwable ex2) {
                    log.error("HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }
}

