/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.jobs;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.linglong.client.domain.dto.JobInvokerInfoDto;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.params.JobCallback;
import cn.com.duiba.linglong.client.domain.params.JobRunningCallback;
import cn.com.duiba.linglong.client.job.WorkerScheduleProperties;
import cn.com.duiba.linglong.client.job.consumer.JobConsumerAssert;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobRunnable;
import cn.com.duiba.linglong.client.remoteservice.RemoteActionCallbackService;
import cn.com.duiba.linglong.client.service.channel.JobLevel;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WorkerScheduleJobManager
implements JobConsumerAssert {
    private static final Logger log = LoggerFactory.getLogger(WorkerScheduleJobManager.class);
    private static final int MAX_ERROR_COUNT = 6;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private WorkerScheduleProperties scheduleProperties;
    @Resource
    private RemoteActionCallbackService remoteActionCallbackService;
    private final LoadingCache<JobKey, WorkerJobRunnable> runnings = Caffeine.newBuilder().removalListener((key, runnable, cause) -> {
        assert (runnable != null);
        if (runnable.isRunning()) {
            runnable.stopAsync();
        }
    }).build(jobKey -> {
        WorkerJobRunnable runnable = (WorkerJobRunnable)((Object)((Object)this.applicationContext.getBean(WorkerJobRunnable.class)));
        runnable.setJobKey((JobKey)jobKey);
        return runnable;
    });

    public synchronized void submitScheduleJob(JobKey jobKey, JobLevel jobLevel) {
        WorkerJobRunnable runnable = (WorkerJobRunnable)((Object)this.runnings.getIfPresent((Object)jobKey));
        if (Objects.nonNull((Object)runnable)) {
            return;
        }
        WorkerJobRunnable newRunnable = (WorkerJobRunnable)((Object)this.runnings.get((Object)jobKey));
        Objects.requireNonNull(newRunnable);
        newRunnable.setJobLevel(jobLevel);
        newRunnable.startAsync();
    }

    public JobInvokerInfoDto runningAck(JobRunningCallback callback) throws BizException {
        WorkerJobRunnable runnable = (WorkerJobRunnable)((Object)this.runnings.getIfPresent((Object)callback.getJobKey()));
        if (Objects.isNull((Object)runnable)) {
            throw new RuntimeException("\u4efb\u52a1\u672a\u6ce8\u518c");
        }
        int errorCount = 0;
        while (runnable.isRunning() && errorCount < 6) {
            try {
                return this.remoteActionCallbackService.runningAck(callback);
            }
            catch (BizException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u8fd0\u884c\u56de\u8c03\u5931\u8d25", (Throwable)e);
                ++errorCount;
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    log.error("\u91cd\u8bd5\u7b49\u5f85\u4e2d\u65ad", (Throwable)interruptedException);
                }
            }
        }
        throw new BizException("\u4efb\u52a1\u8fd0\u884c\u56de\u8c03\u5931\u8d25");
    }

    public void jobCallback(JobCallback callback) throws BizException {
        WorkerJobRunnable runnable = (WorkerJobRunnable)((Object)this.runnings.getIfPresent((Object)callback.getJobKey()));
        if (Objects.isNull((Object)runnable) || !runnable.isRunning()) {
            return;
        }
        int errorCount = 0;
        while (runnable.isRunning() && errorCount < 6) {
            try {
                this.remoteActionCallbackService.jobCallback(callback);
                return;
            }
            catch (BizException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u8fd0\u884c\u56de\u8c03\u5931\u8d25", (Throwable)e);
                ++errorCount;
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    log.error("\u91cd\u8bd5\u7b49\u5f85\u4e2d\u65ad", (Throwable)interruptedException);
                }
            }
        }
    }

    public void cancelJob(JobKey key) {
        WorkerJobRunnable runnable = (WorkerJobRunnable)((Object)this.runnings.getIfPresent((Object)key));
        if (Objects.isNull((Object)runnable) || !runnable.isRunning()) {
            return;
        }
        runnable.cancel();
        this.runnings.invalidate((Object)key);
    }

    public List<JobKey> findAllRunningJobs() {
        return Lists.newArrayList(this.runnings.asMap().keySet());
    }

    public void clearJob(JobKey jobKey) {
        this.runnings.invalidate((Object)jobKey);
    }

    @Override
    public boolean canConsumer() {
        return this.runnings.estimatedSize() < (long)this.scheduleProperties.getMaxJobSize().intValue();
    }
}

