/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.render;

import cn.com.duiba.linglong.client.job.render.TimeConstantBeanResolver;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class DateTool
extends Number {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final Long timestamp;

    public DateTool(Date date) {
        this.timestamp = date.getTime();
    }

    public DateTool(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Object el(String elExpression) {
        Expression expression = PARSER.parseExpression(elExpression);
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new TimeConstantBeanResolver());
        return expression.getValue((EvaluationContext)context, (Object)this);
    }

    public DateTool addDay(int amount) {
        return this.add(6, amount);
    }

    public DateTool add(String fieldName, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        if (!TimeConstantBeanResolver.FIELD_NAME_MAP.containsKey(fieldName)) {
            throw new RuntimeException("\u65e0\u6548\u7684\u65f6\u95f4\u5b57\u6bb5\u540d\u79f0:" + fieldName);
        }
        int field = TimeConstantBeanResolver.FIELD_NAME_MAP.get(fieldName);
        calendar.add(field, amount);
        return new DateTool(calendar.getTimeInMillis());
    }

    public int field(String fieldName) {
        if (!TimeConstantBeanResolver.FIELD_NAME_MAP.containsKey(fieldName)) {
            throw new RuntimeException("\u65e0\u6548\u7684\u65f6\u95f4\u5b57\u6bb5\u540d\u79f0" + fieldName);
        }
        int field = TimeConstantBeanResolver.FIELD_NAME_MAP.get(fieldName);
        return this.field(field);
    }

    public int field(int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        return calendar.get(field);
    }

    public DateTool add(int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        calendar.add(field, amount);
        return new DateTool(calendar.getTimeInMillis());
    }

    public String format(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(this.timestamp));
    }

    public Long currentTimestamp() {
        return System.currentTimeMillis();
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.format("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public int intValue() {
        return this.timestamp.intValue();
    }

    @Override
    public long longValue() {
        return this.timestamp;
    }

    @Override
    public float floatValue() {
        return this.timestamp.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.timestamp.doubleValue();
    }

    public static void main(String[] args) {
        DateTool tool = new DateTool(new Date());
        System.out.println(tool.el("@YEAR"));
        System.out.println(tool.el("#this.field('MONTH')"));
        System.out.println(tool.el("#this == #root"));
        System.out.println(tool.el("#this.field('MONTH') > 2 ? #this.field(@MONTH):#this.field(@MONTH)-10"));
        System.out.println(tool.el("#this.addDay(1)"));
        System.out.println(tool.el("#this.field(@DAY_OF_YEAR)"));
        System.out.println(tool.add("MONTH", 4));
    }
}

