package cn.com.duiba.linglong.client.domain.responce;

import com.alibaba.fastjson.JSONObject;

/**
 * @author liuyao
 */
public class WorkerResult extends JSONObject{

    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    public static final String DATA = "data";

    private WorkerResult(){}

    /**
     * 构造一个成功状态的数据
     */
    public static WorkerResult successResult() {
        WorkerResult resp = new WorkerResult();
        resp.put(SUCCESS, true);
        return resp;
    }

    /**
     * 为了兼容旧接口，新数据接口请使用data做数据返回
     */
    public static WorkerResult successResult(JSONObject model) {
        WorkerResult resp = new WorkerResult();
        resp.put(WorkerResult.SUCCESS, true);
        resp.putAll(model);
        return resp;
    }

    /**
     * 用给定data构造一个成功状态的数据
     */
    public static WorkerResult successResult(Object obj) {
        WorkerResult resp = new WorkerResult();
        resp.put(WorkerResult.SUCCESS, true);
        resp.put(WorkerResult.DATA, obj);
        return resp;
    }

    /**
     * 用失败信息构造一个失败状态的数据
     */
    public static WorkerResult failResult(String message) {
        WorkerResult resp = new WorkerResult();
        resp.put(WorkerResult.SUCCESS, false);
        resp.put(WorkerResult.MESSAGE, message);
        return resp;
    }

    /**
     * 异常信息构造一个失败状态的数据
     */
    public static WorkerResult failResult(Throwable e) {
        WorkerResult resp = new WorkerResult();
        resp.put(WorkerResult.SUCCESS, false);
        resp.put(WorkerResult.MESSAGE, e.getMessage());
        return resp;
    }


    /**
     * 请求处理结果
     */
    public boolean isSuccess() {
        return this.getBoolean(WorkerResult.SUCCESS);
    }

    public String getMessage(){
        return this.getString(WorkerResult.MESSAGE);
    }

}
