package cn.com.duiba.linglong.client.job.jobs;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.exception.WorkerException;
import cn.com.duiba.linglong.client.service.logger.JobLogger;

/**
 * @author liuyao
 */
public abstract class AbstractJob{

	protected JobLogger jobLogger;

	protected JobContext jobContext;

	private volatile boolean running = true;

	public void setJobContext(JobContext jobContext){
		this.jobContext=jobContext;
	}

	public void setJobLogger(JobLogger jobLogger) {
		this.jobLogger = jobLogger;
	}

	public abstract void run() throws WorkerException;

	protected abstract void cancelInternal();

	public boolean isRunning() {
		return running;
	}

	public synchronized void cancel(){
		if(!running){
			return;
		}
		cancelInternal();
		running = false;
	}

	public JobContext getJobContext() {
		return jobContext;
	}

	public void log(String log){
		jobLogger.log(Level.DEBUG,log);
	}

	public void log(Level level,String log){
		jobLogger.log(level,log);
	}

	public void log(Throwable e){
		jobLogger.error(e);
	}

}