package cn.com.duiba.linglong.client.service;

import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.event.JobCancelEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import org.springframework.context.ApplicationContext;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import java.util.UUID;

/**
 * 任务运行状态管理器
 * @author liuyao
 */
public class JobStatusManager {

    @Resource
    private HazelcastInstance linglongHazelcastClient;
    @Resource
    private ApplicationContext applicationContext;

    private ITopic<JobCancelEvent> jobCancelEventTopic;

    private UUID listenerId;

    @PostConstruct
    public void init(){
        jobCancelEventTopic = linglongHazelcastClient.getTopic("JobStatusManager.jobCancelEventTopic");
        listenerId = jobCancelEventTopic.addMessageListener(message -> applicationContext.publishEvent(message.getMessageObject()));
    }

    @PreDestroy
    public void preDestroy(){
        jobCancelEventTopic.removeMessageListener(listenerId);
    }

    public void cancelJob(JobKey jobKey){
        JobCancelEvent event = new JobCancelEvent();
        event.setHistoryId(jobKey.getHistoryId());
        event.setInvokeType(jobKey.getInvokeType());
        jobCancelEventTopic.publish(event);
    }





}
