## 玲珑分布式任务调度

## 1.新建任务类型
在玲珑的管理界面

系统设置 -> 任务类型 -> 新建任务类型
选择支持运行任务的应用时，选择自己将要对接的应用

## 2.新建任务
新建任务时选择自己的创建的任务类型
然后进行脚本编辑

## 2.玲珑客户端接入
首先声明一个任务类，继承玲珑的抽象任务类 AbstractJob
并注册到String Ioc容器中

注意！任务类必须是原型的

```
/**
 * 清理发号表
 * @author liuyao
 */
@Component
@Scope("prototype")
public class CleanTableJob extends AbstractJob {

    @Override
    public void run() throws WorkerException {

        //获取脚本
        String script = jobContext.getScript();
        //获取配置
        String value = jobContext.getProperty("配置Key");
        //获取任务执行时间
        Date time = jobContext.getTime();

        //做任务想做的事情
        
        //有WorkerException抛出，任务就会失败
        // throw new WorkerException()

        //调用玲珑提供的日志方法，日志就会出现在玲珑服务的日志窗口上
        log("打日志");
    }

    @Override
    protected void cancelInternal() {
        //取消任务时要做的事情
    }
}
```

定义好任务类后，添加配置，开启调度，然后将玲珑上定义好的任务类型和任务类关联
```
linglong.sdk.schedule.enable = true

linglong.sdk.schedule.jobs.[任务类型标识]	= 任务类Class
```

对接完成！






