package cn.com.duiba.linglong.client.job;

import cn.com.duiba.linglong.client.job.consumer.WorkerJobConsumer;
import cn.com.duiba.linglong.client.job.consumer.WorkerJobController;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobBeanFactoryPostProcessor;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobFactory;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobRunnable;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.linglong.client.job.render.ConfigRender;
import cn.com.duiba.linglong.client.job.render.JobScriptInterceptor;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import org.apache.http.client.HttpClient;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import java.util.concurrent.*;

/**
 * @author liuyao
 */
@Configuration
@ConditionalOnProperty(name="linglong.sdk.schedule.enable", havingValue="true")
@EnableConfigurationProperties(WorkerScheduleProperties.class)
public class WorkerScheduleConfiguration {

    @Bean
    public static WorkerJobBeanFactoryPostProcessor linglongAbstractJobBeanFactoryPostProcessor(){
        return new WorkerJobBeanFactoryPostProcessor();
    }

    @Bean
    public WorkerJobFactory workerJobFactory(){
        return new WorkerJobFactory();
    }

    @Bean
    public WorkerJobConsumer workerJobConsumer(){
        return new WorkerJobConsumer();
    }

    @Bean
    public WorkerScheduleJobManager workerScheduleJobManager(){
        return new WorkerScheduleJobManager();
    }

    @Bean
    public WorkerJobController workerJobController(){
        return new WorkerJobController();
    }

    @Bean
    @Scope("prototype")
    public WorkerJobRunnable workerJobRunnable(){
        return new WorkerJobRunnable();
    }

    @Bean
    public ExecutorService workerActionExecutorService(WorkerScheduleProperties scheduleProperties){
        ThreadFactory threadFactory = new NamedThreadFactory("workerAction");
        return new ThreadPoolExecutor(scheduleProperties.getMaxJobSize(), scheduleProperties.getMaxJobSize()*2,
                3L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(500),threadFactory);
    }

    @Bean
    @Order(2)
    public JobScriptInterceptor jobScriptInterceptor(){
        return new JobScriptInterceptor();
    }

    @Bean(initMethod = "init")
    public VelocityEngine velocityEngine(){
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty(RuntimeConstants.RESOURCE_LOADER, "classpath");
        velocityEngine.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        velocityEngine.setProperty("input.encoding","UTF-8");
        velocityEngine.setProperty("output.encoding","UTF-8");
        return velocityEngine;
    }

    @Bean
    @Scope("prototype")
    public ConfigRender configRender(){
        return new ConfigRender();
    }

    @LoadBalanced
    @Bean
    public RestTemplate linglongFetchJobRestTemplate(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(3000);
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(10000);
        httpRequestFactory.setHttpClient(httpClient);
        return new RestTemplate(httpRequestFactory);
    }


}
