package cn.com.duiba.linglong.client.job.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import org.jetbrains.annotations.NotNull;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;

import java.util.Calendar;
import java.util.Map;
import java.util.Objects;

import static java.util.Calendar.*;

/**
 * @author liuyao
 */
public class TimeConstantBeanResolver implements BeanResolver {

    public static final Map<String,Integer> FIELD_NAME_MAP;

    private static final Map<String,Integer> CONSTANT_MAP;
    static{
        //时间单位常量
        Map<String,Integer> insideFieldNameMap = Maps.newHashMap();
        insideFieldNameMap.put("ERA", Calendar.ERA);
        insideFieldNameMap.put("YEAR",Calendar.YEAR);
        insideFieldNameMap.put("MONTH",Calendar.MONTH);
        insideFieldNameMap.put("WEEK_OF_YEAR",Calendar.WEEK_OF_YEAR);
        insideFieldNameMap.put("WEEK_OF_MONTH",Calendar.WEEK_OF_MONTH);
        insideFieldNameMap.put("DATE",Calendar.DATE);
        insideFieldNameMap.put("DAY_OF_MONTH",Calendar.DAY_OF_MONTH);
        insideFieldNameMap.put("DAY_OF_YEAR",Calendar.DAY_OF_YEAR);
        insideFieldNameMap.put("DAY_OF_WEEK",Calendar.DAY_OF_WEEK);
        insideFieldNameMap.put("DAY_OF_WEEK_IN_MONTH",Calendar.DAY_OF_WEEK_IN_MONTH);
        insideFieldNameMap.put("AM_PM",Calendar.AM_PM);
        insideFieldNameMap.put("HOUR",Calendar.HOUR);
        insideFieldNameMap.put("HOUR_OF_DAY",Calendar.HOUR_OF_DAY);
        insideFieldNameMap.put("MINUTE",Calendar.MINUTE);
        insideFieldNameMap.put("SECOND",Calendar.SECOND);
        insideFieldNameMap.put("MILLISECOND",Calendar.MILLISECOND);
        insideFieldNameMap.put("ZONE_OFFSET",Calendar.ZONE_OFFSET);
        insideFieldNameMap.put("DST_OFFSET",Calendar.DST_OFFSET);
        insideFieldNameMap.put("FIELD_COUNT",Calendar.FIELD_COUNT);
        FIELD_NAME_MAP = ImmutableMap.copyOf(insideFieldNameMap);
        //时间变量常量
        Map<String,Integer> insideConstantMap = Maps.newHashMap();
        //星期
        insideConstantMap.put("SUNDAY",SUNDAY);
        insideConstantMap.put("MONDAY",MONDAY);
        insideConstantMap.put("TUESDAY",TUESDAY);
        insideConstantMap.put("WEDNESDAY",WEDNESDAY);
        insideConstantMap.put("THURSDAY",THURSDAY);
        insideConstantMap.put("FRIDAY",FRIDAY);
        insideConstantMap.put("SATURDAY",SATURDAY);
        //月份
        insideConstantMap.put("JANUARY",JANUARY);
        insideConstantMap.put("FEBRUARY",FEBRUARY);
        insideConstantMap.put("MARCH",MARCH);
        insideConstantMap.put("APRIL",APRIL);
        insideConstantMap.put("MAY",MAY);
        insideConstantMap.put("JUNE",JUNE);
        insideConstantMap.put("JULY",JULY);
        insideConstantMap.put("AUGUST",AUGUST);
        insideConstantMap.put("SEPTEMBER",SEPTEMBER);
        insideConstantMap.put("OCTOBER",OCTOBER);
        insideConstantMap.put("NOVEMBER",NOVEMBER);
        insideConstantMap.put("DECEMBER",DECEMBER);
        CONSTANT_MAP = ImmutableMap.copyOf(insideConstantMap);;
    }

    @NotNull
    @Override
    public Object resolve(@NotNull EvaluationContext context, @NotNull String beanName) throws AccessException {
        Integer fieldName = FIELD_NAME_MAP.get(beanName);
        if(Objects.nonNull(fieldName)){
            return fieldName;
        }
        Integer constant = CONSTANT_MAP.get(beanName);
        if(Objects.nonNull(constant)){
            return constant;
        }
        throw new AccessException("未能关联到常量:"+beanName);
    }
}
