package cn.com.duiba.linglong.client.service.logger;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.exception.WorkerException;
import cn.com.duiba.linglong.client.service.logger.appender.JobLoggerAppender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author liuyao
 */
@Slf4j
public class JobLogger {

    public static final int JOB_LOG_CONUT_LIMIT = 10000;

    private final JobLoggerAppender jobLoggerAppender;

    private final JobKey jobKey;

    private final AtomicInteger jobLogCount = new AtomicInteger(0);

    private volatile boolean isUp = false;

    public JobLogger(JobLoggerAppender jobLoggerAppender, JobKey jobKey){
        this.jobLoggerAppender = jobLoggerAppender;
        this.jobKey = jobKey;
    }

    public JobKey getJobKey() {
        return jobKey;
    }

    public void log(String log) {
        log(null,log);
    }

    public void error(Throwable e) {
        if(e instanceof WorkerException){
            log(Level.ERROR,e.getMessage());
        }else if(e instanceof NullPointerException){
            StringWriter out = new StringWriter();
            try(PrintWriter stream = new PrintWriter(out)){
                e.printStackTrace(stream);
                log(Level.ERROR,"任务空指针异常:"+ out);
            }
        }else{
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            log(Level.ERROR,sw.toString());
        }
    }

    public void log(Level level,String logContent){
        if(StringUtils.isBlank(logContent)){
            return;
        }
        int count = jobLogCount.getAndIncrement();
        if(count > JOB_LOG_CONUT_LIMIT){
            if(!isUp){
                String context = "任务["+jobKey.key()+"]日志量超过"+JOB_LOG_CONUT_LIMIT+",无法继续记录";
                JobLog jobLog = new JobLog();
                jobLog.setActionTime(System.currentTimeMillis());
                jobLog.setLogContent(context);
                jobLog.setLevel(Level.ERROR.toString());
                jobLoggerAppender.acceptLog(jobKey,jobLog);
            }
            isUp = true;
            return;
        }
        JobLog jobLog = new JobLog();
        jobLog.setActionTime(System.currentTimeMillis());
        jobLog.setLogContent(logContent);
        jobLog.setLevel(Optional.ofNullable(level).orElse(Level.INFO).toString());
        jobLoggerAppender.acceptLog(jobKey,jobLog);
    }

}
