/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.jobs;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.domain.dto.JobInvokerInfoDto;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.params.JobCallback;
import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import cn.com.duiba.linglong.client.job.jobs.JobContext;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobFactory;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.linglong.client.service.channel.JobLevel;
import cn.com.duiba.linglong.client.service.logger.JobLogger;
import cn.com.duiba.linglong.client.service.logger.appender.JobLoggerAppender;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerJobRunnable
extends AbstractExecutionThreadService {
    private static final Logger log = LoggerFactory.getLogger(WorkerJobRunnable.class);
    @Resource
    private WorkerJobFactory workerJobFactory;
    @Resource(name="workerActionExecutorService")
    private ExecutorService workerActionExecutorService;
    @Resource
    private WorkerScheduleJobManager workerScheduleJobManager;
    @Resource
    private JobLoggerAppender jobLoggerAppender;
    private volatile AbstractJob delegateJob;
    private JobKey jobKey;
    private JobLevel jobLevel;
    private JobLogger jobLogger;
    private JobInvokerInfoDto invokerInfo;

    protected void startUp() {
        this.jobLogger = new JobLogger(this.jobLoggerAppender, this.jobKey);
    }

    public void run() {
        JobCallback event = new JobCallback();
        event.setJobKey(this.jobKey);
        try {
            JobContext jobContext = new JobContext();
            jobContext.setJobKey(this.jobKey);
            jobContext.setJobLevel(this.jobLevel);
            jobContext.setRunType(this.invokerInfo.getRunType());
            jobContext.setTime(this.invokerInfo.getFireTime());
            jobContext.setScript(this.invokerInfo.getScript());
            jobContext.putAll((Map<?, ?>)this.invokerInfo.getProperties());
            this.delegateJob = this.workerJobFactory.newInstanceJobByJobRunType(jobContext, this.jobLogger);
            this.delegateJob.run();
            event.setSuccess(true);
        }
        catch (Exception e) {
            this.jobLogger.error(e);
            event.setSuccess(false);
            event.setMessage(e.getMessage());
        }
        try {
            if (Objects.nonNull(this.delegateJob) && !this.delegateJob.isRunning()) {
                return;
            }
            this.workerScheduleJobManager.jobCallback(event);
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u7ed3\u679c\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.workerScheduleJobManager.clearJob(this.jobKey);
        }
    }

    public void cancel() {
        if (Objects.nonNull(this.delegateJob) && this.delegateJob.isRunning()) {
            this.delegateJob.cancel();
            this.jobLogger.log(Level.WARN, "\u53d6\u6d88\u4efb\u52a1");
        }
        if (this.isRunning()) {
            this.stopAsync();
        }
    }

    protected Executor executor() {
        return this.workerActionExecutorService;
    }

    public void setJobKey(JobKey jobKey) {
        this.jobKey = jobKey;
    }

    public void setJobLevel(JobLevel jobLevel) {
        this.jobLevel = jobLevel;
    }

    public void setInvokerInfo(JobInvokerInfoDto invokerInfo) {
        this.invokerInfo = invokerInfo;
    }
}

