/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.render;

import cn.com.duiba.linglong.client.job.interceptor.JobInterceptor;
import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import cn.com.duiba.linglong.client.job.jobs.JobContext;
import cn.com.duiba.linglong.client.job.render.ConfigRender;
import cn.com.duiba.linglong.client.job.render.DateTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class JobScriptInterceptor
implements JobInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JobScriptInterceptor.class);
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public boolean preHandle(AbstractJob job) {
        JobContext jobContext = job.getJobContext();
        job.log("\u4efb\u52a1\u53c2\u7167\u65f6\u95f4:" + DateUtils.getSecondStr((Date)jobContext.getTime()));
        ConfigRender configRender = (ConfigRender)this.applicationContext.getBean(ConfigRender.class);
        configRender.setRepository(jobContext);
        this.prepareProperties(configRender, jobContext);
        jobContext.setScript(this.renderScript(configRender, jobContext.getScript()));
        return true;
    }

    public void prepareProperties(ConfigRender configRender, JobContext jobContext) throws IllegalArgumentException {
        DateTool dateTool = new DateTool(jobContext.getTime()).addDay(-1);
        jobContext.put("yesterday", dateTool.format("yyyyMMdd"));
        jobContext.put("date", dateTool.format("yyyy-MM-dd"));
        ArrayList waitRanderKeys = Lists.newArrayList();
        for (String key : jobContext.stringPropertyNames()) {
            String value = jobContext.getProperty(key);
            Set<String> needKeys = ConfigRender.analyseScript(value);
            if (needKeys.isEmpty()) continue;
            waitRanderKeys.add(key);
        }
        for (String key : waitRanderKeys) {
            String renderValue = configRender.getRenderConfig(key);
            jobContext.put(key, renderValue);
        }
    }

    public String renderScript(ConfigRender configRender, String script) {
        if (StringUtils.isBlank((String)script)) {
            return script;
        }
        Set<String> keys = ConfigRender.analyseScript(script);
        Properties model = new Properties();
        for (String key : keys) {
            model.put(key, configRender.getRenderConfig(key));
        }
        return ConfigRender.replaceArgs(script, model);
    }
}

