/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;

public class TimeConstantBeanResolver
implements BeanResolver {
    public static final Map<String, Integer> FIELD_NAME_MAP;
    private static final Map<String, Integer> CONSTANT_MAP;

    @NotNull
    public Object resolve(@NotNull EvaluationContext context, @NotNull String beanName) throws AccessException {
        Integer fieldName = FIELD_NAME_MAP.get(beanName);
        if (Objects.nonNull(fieldName)) {
            return fieldName;
        }
        Integer constant = CONSTANT_MAP.get(beanName);
        if (Objects.nonNull(constant)) {
            return constant;
        }
        throw new AccessException("\u672a\u80fd\u5173\u8054\u5230\u5e38\u91cf:" + beanName);
    }

    static {
        HashMap insideFieldNameMap = Maps.newHashMap();
        insideFieldNameMap.put("ERA", 0);
        insideFieldNameMap.put("YEAR", 1);
        insideFieldNameMap.put("MONTH", 2);
        insideFieldNameMap.put("WEEK_OF_YEAR", 3);
        insideFieldNameMap.put("WEEK_OF_MONTH", 4);
        insideFieldNameMap.put("DATE", 5);
        insideFieldNameMap.put("DAY_OF_MONTH", 5);
        insideFieldNameMap.put("DAY_OF_YEAR", 6);
        insideFieldNameMap.put("DAY_OF_WEEK", 7);
        insideFieldNameMap.put("DAY_OF_WEEK_IN_MONTH", 8);
        insideFieldNameMap.put("AM_PM", 9);
        insideFieldNameMap.put("HOUR", 10);
        insideFieldNameMap.put("HOUR_OF_DAY", 11);
        insideFieldNameMap.put("MINUTE", 12);
        insideFieldNameMap.put("SECOND", 13);
        insideFieldNameMap.put("MILLISECOND", 14);
        insideFieldNameMap.put("ZONE_OFFSET", 15);
        insideFieldNameMap.put("DST_OFFSET", 16);
        insideFieldNameMap.put("FIELD_COUNT", 17);
        FIELD_NAME_MAP = ImmutableMap.copyOf((Map)insideFieldNameMap);
        HashMap insideConstantMap = Maps.newHashMap();
        insideConstantMap.put("SUNDAY", 1);
        insideConstantMap.put("MONDAY", 2);
        insideConstantMap.put("TUESDAY", 3);
        insideConstantMap.put("WEDNESDAY", 4);
        insideConstantMap.put("THURSDAY", 5);
        insideConstantMap.put("FRIDAY", 6);
        insideConstantMap.put("SATURDAY", 7);
        insideConstantMap.put("JANUARY", 0);
        insideConstantMap.put("FEBRUARY", 1);
        insideConstantMap.put("MARCH", 2);
        insideConstantMap.put("APRIL", 3);
        insideConstantMap.put("MAY", 4);
        insideConstantMap.put("JUNE", 5);
        insideConstantMap.put("JULY", 6);
        insideConstantMap.put("AUGUST", 7);
        insideConstantMap.put("SEPTEMBER", 8);
        insideConstantMap.put("OCTOBER", 9);
        insideConstantMap.put("NOVEMBER", 10);
        insideConstantMap.put("DECEMBER", 11);
        CONSTANT_MAP = ImmutableMap.copyOf((Map)insideConstantMap);
    }
}

