/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.monitor;

import cn.com.duiba.linglong.client.job.consumer.JobConsumerAssert;
import cn.com.duiba.linglong.client.monitor.MonitorProperties;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CpuInfoService
implements JobConsumerAssert {
    private static final Logger log = LoggerFactory.getLogger(CpuInfoService.class);
    private static final List<String> LOAD_PREFIX = Lists.newArrayList((Object[])new String[]{"load average:", "load averages:"});
    private volatile String loadPrefix;
    private final List<String> commands = Lists.newArrayList((Object[])new String[]{"sh", "-c", "uptime"});
    @Resource
    private MonitorProperties monitorProperties;
    private final Integer cpuCoreNum = Runtime.getRuntime().availableProcessors();
    private ProcessBuilder processBuilder;
    private volatile Float cpuloadPercore = Float.valueOf(0.0f);

    @PostConstruct
    public void init() {
        this.processBuilder = new ProcessBuilder(this.commands);
        this.processBuilder.redirectErrorStream(true);
        String uptime = this.uptime();
        for (String prefix : LOAD_PREFIX) {
            if (!uptime.contains(prefix)) continue;
            this.loadPrefix = prefix;
            break;
        }
    }

    private String uptime() {
        try {
            Process process = this.processBuilder.start();
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            catch (Exception e) {
                log.debug("shell\u6267\u884c\u7ed3\u679c\u76d1\u542c\u5931\u8d25", (Throwable)e);
            }
            int exit = process.waitFor();
            if (exit != 0) {
                log.error("uptime error:{}", (Object)stringBuilder);
                return "";
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            log.error("upTime\u6267\u884c\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    @Scheduled(cron="0/3 * * * * ?")
    public void runOneIteration() {
        if (StringUtils.isBlank((String)this.loadPrefix)) {
            return;
        }
        String uptime = this.uptime();
        if (StringUtils.isBlank((String)uptime)) {
            return;
        }
        int index = uptime.indexOf(this.loadPrefix);
        String sub = uptime.substring(index).substring(this.loadPrefix.length()).trim();
        String[] tmps = sub.split(",");
        if (tmps.length == 1) {
            tmps = sub.split(" ");
        }
        Float cpuload = Float.valueOf(tmps[0].trim());
        this.cpuloadPercore = Float.valueOf(cpuload.floatValue() / (float)this.cpuCoreNum.intValue());
    }

    @Override
    public boolean canConsumer() {
        if (this.cpuloadPercore.floatValue() > this.monitorProperties.getMaxCpuLoadPerCore().floatValue()) {
            log.info("CPU\u8fc7\u8f7d\uff1amax(" + this.monitorProperties.getMaxCpuLoadPerCore() + "),current:(" + this.cpuloadPercore + ")");
            return false;
        }
        return true;
    }
}

