package cn.com.duiba.linglong.client.job;

import cn.com.duiba.linglong.client.job.consumer.WorkerJobConsumer;
import cn.com.duiba.linglong.client.job.consumer.WorkerJobController;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobFactory;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobRunnable;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import java.util.concurrent.*;

/**
 * @author liuyao
 */
@Configuration
@ConditionalOnProperty(name="linglong.sdk.schedule.enable", havingValue="true")
@EnableConfigurationProperties(ScheduleProperties.class)
public class WorkerScheduleConfiguration {

    @Bean
    public WorkerJobConsumer workerJobConsumer(){
        return new WorkerJobConsumer();
    }

    @Bean
    public WorkerJobFactory workerJobFactory(){
        return new WorkerJobFactory();
    }

    @Bean
    public WorkerScheduleJobManager workerScheduleJobManager(){
        return new WorkerScheduleJobManager();
    }

    @Bean
    public WorkerJobController workerJobController(){
        return new WorkerJobController();
    }

    @Bean
    @Scope("prototype")
    public WorkerJobRunnable workerJobRunnable(){
        return new WorkerJobRunnable();
    }

    @Bean
    public ExecutorService workerActionExecutorService(ScheduleProperties scheduleProperties){
        ThreadFactory threadFactory = new NamedThreadFactory("workerAction");
        return new ThreadPoolExecutor(scheduleProperties.getMaxJobSize(), scheduleProperties.getMaxJobSize()*2,
                3L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(500),threadFactory);
    }




}
