/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.cluster.hazelcast;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.linglong.client.cluster.hazelcast.Node;
import cn.com.duiba.linglong.client.cluster.zookeeper.ZookeeperProperties;
import cn.com.duiba.linglong.client.utils.IOUtils;
import com.google.common.collect.Lists;
import com.hazelcast.cluster.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.partitiongroup.PartitionGroupStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.UriSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ZookeeperDiscoveryStrategy
implements DiscoveryStrategy {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperDiscoveryStrategy.class);
    @Resource
    private CuratorFramework curatorFramework;
    @Resource
    private ZookeeperProperties canalZookeeperProperties;
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${server.port}")
    private int httpServerPort;
    private DiscoveryNode discoveryNode;
    private ServiceDiscovery<Node> serviceDiscovery;
    private ServiceInstance<Node> serviceInstance;

    void setDiscoveryNode(DiscoveryNode discoveryNode) {
        this.discoveryNode = discoveryNode;
    }

    private boolean isMember() {
        return this.discoveryNode != null;
    }

    public ServiceInstance<Node> getThisServiceInstance() {
        return this.serviceInstance;
    }

    public ServiceDiscovery<Node> getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void start() {
        try {
            ServiceDiscoveryBuilder discoveryBuilder = ServiceDiscoveryBuilder.builder(Node.class).basePath(this.canalZookeeperProperties.getRootPath()).client(this.curatorFramework);
            this.prepareServiceInstance();
            discoveryBuilder.thisInstance(this.serviceInstance);
            this.serviceDiscovery = discoveryBuilder.build();
            this.serviceDiscovery.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper. ", e);
        }
    }

    private void prepareServiceInstance() throws Exception {
        Node node = new Node();
        String address = NetUtils.getLocalIp();
        if (this.isMember()) {
            Address privateAddress = this.discoveryNode.getPrivateAddress();
            address = privateAddress.getHost();
            node.setHzPort(privateAddress.getPort());
        }
        node.setWeight(100);
        this.serviceInstance = ServiceInstance.builder().id(address + ":" + this.httpServerPort).uriSpec(new UriSpec("{scheme}://{address}:{port}")).address(address).port(this.httpServerPort).name(this.appName).payload((Object)node).build();
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList nodes = Lists.newArrayList();
        try {
            Collection instances = this.serviceDiscovery.queryForInstances("linglong");
            for (ServiceInstance serviceInstance : instances) {
                String host = serviceInstance.getAddress();
                int port = ((Node)serviceInstance.getPayload()).getHzPort();
                Address address = new Address(host, port);
                SimpleDiscoveryNode node = new SimpleDiscoveryNode(address);
                nodes.add(node);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        return nodes;
    }

    public Collection<ServiceInstance<Node>> members(String hostGroup) {
        try {
            return this.serviceDiscovery.queryForInstances(hostGroup);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
    }

    public ServiceInstance<Node> findServiceInstanceByMember(String hostGroup, String address) {
        try {
            return this.serviceDiscovery.queryForInstance(hostGroup, address);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
    }

    public void destroy() {
        try {
            if (this.isMember() && this.serviceDiscovery != null) {
                this.serviceDiscovery.unregisterService(this.serviceInstance);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        finally {
            IOUtils.closeSafely(this.serviceDiscovery);
        }
    }

    public PartitionGroupStrategy getPartitionGroupStrategy() {
        return null;
    }

    public Map<String, String> discoverLocalMetadata() {
        return Collections.emptyMap();
    }
}

